/* Copyright (C) 2012-2018 RealVNC Ltd. All Rights Reserved.
 *
 * This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#ifndef UUID_50e6aa84_947e_f1e4_70cc_01123c5cb2e4
#define UUID_50e6aa84_947e_f1e4_70cc_01123c5cb2e4

#ifdef _WIN32_WCE
#include <winsock2.h>
#endif
#ifndef _WIN32
#include <unistd.h>
#else
#define close closesocket
#endif


namespace vncdiscovery
{
  template<typename T>
  class AutoFreePtr
  {
  public:
    AutoFreePtr(T* pObj=NULL)
      : mpObj(pObj)
    {}

    ~AutoFreePtr()
    {
      if(mpObj)
        free(mpObj);
    }

    T* get()
    { return mpObj; }

    T* release()
    {
      T* pObj = mpObj;
      mpObj = NULL;
      return pObj;
    }

    void reset(T* pObj=NULL)
    {
      if(mpObj)
        free(mpObj);
      mpObj = pObj;
    }

    T* operator->()
    {
      return mpObj;
    }

  private:
    AutoFreePtr(const AutoFreePtr& other);
    const AutoFreePtr& operator=(const AutoFreePtr& other);

  private:
    T* mpObj;
  };

  class AutoCloseSocket
  {
  public:
    AutoCloseSocket(int sck)
      : mSck(sck)
    { }

    ~AutoCloseSocket()
    { close(mSck); }

    int get()
    { return mSck; }

  private:
    int mSck;
  };


  template<typename T>
  class AutoCustomDestroy
  {
  public:
    typedef void (CustomDestroyFn)(T*);

    AutoCustomDestroy(CustomDestroyFn* pDestroy, T* pObj=NULL)
      : mpObj(pObj),
        mpDestroy(pDestroy)
    {}

    ~AutoCustomDestroy()
    {
      if(mpObj)
        (*mpDestroy)(mpObj);
    }

    T* get()
    { return mpObj; }

    T* release()
    {
      T* pObj = mpObj;
      mpObj = NULL;
      return pObj;
    }

    void reset(T* pObj=NULL)
    {
      if(mpObj)
        (*mpDestroy)(mpObj);
      mpObj = pObj;
    }

    T* operator->()
    {
      return mpObj;
    }

  private:
    AutoCustomDestroy(const AutoCustomDestroy& other);
    const AutoCustomDestroy& operator=(const AutoCustomDestroy& other);

  private:
    T* mpObj;
    CustomDestroyFn* mpDestroy;
  };

} // namespace vncdiscovery

#endif /* ! defined(UUID_50e6aa84_947e_f1e4_70cc_01123c5cb2e4) */

